#include <stdio.h>
#include <stdlib.h>
#include "common.h"

/* shows how multiple threads update a shared counter, causing a race. using an
 * atomic increment avoids the race. */

volatile long counter = 0;
/* initialize from user input */
long loops;

int atomic = 0;

/* increment counter by loops times */
void *
worker(void *arg)
{
	int i;
	if (!atomic) {
		for (i = 0; i < loops; i++) {
			counter++;
		}
	} else {
		for (i = 0; i < loops; i++) {
			// atomic version of counter++
			__atomic_fetch_add(&counter, 1, __ATOMIC_SEQ_CST);
		}
	}
	return NULL;
}

int
main(int argc, char *argv[])
{
	if (argc != 2 && argc != 3) {
		fprintf(stderr, "usage: threads -a <loops>\n");
		exit(1);
	}
	if (argc == 2) {
		loops = atol(argv[1]);
	} else {
		atomic = 1;
		loops = atol(argv[2]);
	}
	pthread_t p1, p2;
	printf("Loops: %ld\n", loops);
	printf("Initial counter value: %ld\n", counter);
	/* create two threads, both threads run worker() */
	Pthread_create(&p1, NULL, worker, NULL);
	Pthread_create(&p2, NULL, worker, NULL);
	/* wait for the two threads to finish executing */
	Pthread_join(p1, NULL);
	Pthread_join(p2, NULL);
	/* print the value of the counter global variable */
	/* we expect the value of counter = 2 * loops */
	printf("Final counter value:   %ld\n", counter);
	return 0;
}
